using System;
using System.Collections;

namespace com.swvoyages.reservation {

	///
	/// <summary>L'interface <code>ReservationRegistry</code> dfinit 
	/// le registre de toutes les rservations en cours dans le processus 
	/// d'excution courant (application).</summary>
	///
	interface ReservationRegistry {

		///
		/// <summary>Purge le registre des rservations.</summary>
		///
		void clear();

		///
		/// <summary>Renvoie la table des rservations en cours (clone).
		/// </summary>
		///
		/// <returns>la table des rservations en cours</returns>
		///
		Hashtable getAllReservations();

		///
		/// <summary>Renvoie la rservation correspondant  l'identifiant 
		/// pass en paramtre, si elle existe dans le registre, <b>null</b> 
		/// sinon.</summary>
		///
		/// <param name="reservationId">l'identifiant de la rservation
		/// </param>
		///
		/// <returns>la rservation rfrence par l'identifiant 
		///	reservationId; <b>null</b> sinon</returns>
		///
		Object getReservation(Object reservationId);

		///
		/// <summary>Initialise le registre des rservations.</summary>
		///
		void initialize();

		///
		/// <summary>Renvoie <b>true</b> si le registre rfrence des 
		/// rservations en cours.</summary>
		///
		/// <returns><code>true</code> si le registre contient des
		///	rservations; <code>false</code> sinon<returns>
		///
		bool isEmpty();

		///
		/// <summary>Renvoie <b>true</b> si la rservation passe en 
		/// paramtre est enregistre.</summary>
		///
		/// <param name="reservation">la rservation  vrifier</param>
		///
		/// <returns><code>true</code> si la rservation est
		///	enregistre; <code>false</code> sinon</returns>
		///
		bool isReservationRegistered(Object reservation);

		///
		/// <summary>Enregistre une nouvelle rservation.</summary>
		///
		/// <param name="reservationId">l'identifiant de la rservation
		/// </param> 
		/// <param name="reservation">la rservation</param>
		///
		/// <returns>la nouvelle rservation enregistre</returns>
		///
		/// <exception cref="ReservationException">lance si une anomalie 
		/// se produit durant l'enregistrement de la rservation</exception>
		///
		Object newReservation(Object reservationId, Object reservation);

		///
		/// <summary>Libre les rservations du registre.</summary>
		///
		void release();

		///
		/// <summary>Supprime la rservation identifie du registre.
		/// </summary>
		///
		/// <param name="reservationId">l'identifiant de la rservation
		/// </param>
		///
		void removeReservation(Object reservationId);

		///
		/// <summary>Renvoie le nombre des rservations en cours.</summary>
		///
		/// <returns>le nombre des rservations en cours</returns>
		///
		int size();
	}
}